/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.Restrictions;
import com.moulberry.axiom.ServerConfig;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.bedrock.BedrockModelRegistry;
import com.moulberry.axiom.bedrock.BedrockPackLoader;
import com.moulberry.axiom.clipboard.Clipboard;
import com.moulberry.axiom.clipboard.ClipboardObject;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.configuration.Configuration;
import com.moulberry.axiom.configuration.InternalConfiguration;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.ImageReferenceWindows;
import com.moulberry.axiom.editor.json_model.BlocksToJsonModel;
import com.moulberry.axiom.editor.keybinds.Keybinds;
import com.moulberry.axiom.editor.schematic.SchematicLoader;
import com.moulberry.axiom.editor.tutorial.Tutorial;
import com.moulberry.axiom.editor.tutorial.TutorialManager;
import com.moulberry.axiom.editor.views.ViewManager;
import com.moulberry.axiom.editor.windows.operations.FillBlocksWindow;
import com.moulberry.axiom.editor.windows.save_world.ExportSchematicWindow;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.operations.DrainOperation;
import com.moulberry.axiom.operations.FillNearestOperation;
import com.moulberry.axiom.operations.GenerateColourFieldOperation;
import com.moulberry.axiom.operations.HollowOperation;
import com.moulberry.axiom.operations.SimulateGravityOperation;
import com.moulberry.axiom.operations.UpdateBlocksOperation;
import com.moulberry.axiom.operations.WaterlogOperation;
import com.moulberry.axiom.operations.smooth.SmoothSnow;
import com.moulberry.axiom.render.BiomeOverlayRenderer;
import com.moulberry.axiom.utils.AsyncFileDialogs;
import com.moulberry.axiom.world_modification.Dispatcher;
import imgui.ImGui;
import imgui.type.ImBoolean;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_407;
import net.minecraft.class_437;
import net.minecraft.class_5253;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

public class MainMenuBar {
    public static void render() {
        if (ImGui.beginMainMenuBar()) {
            Object data;
            boolean clipboardNonEmpty;
            ServerConfig config = Axiom.getInstance().serverConfig;
            boolean selectionActive = !Selection.getSelectionBuffer().isEmpty();
            boolean clipboardEmpty = Clipboard.INSTANCE.getClipboard() == null;
            boolean bl = clipboardNonEmpty = !clipboardEmpty;
            if (ImGui.beginMenu(AxiomI18n.get("axiom.editorui.mainmenu.file"))) {
                Object dirStr;
                Path path2;
                CompletableFuture<String> future;
                String separator;
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.file.import_schematic"))) {
                    if (!Restrictions.canImportBlocks) {
                        class_746 player = class_310.method_1551().field_1724;
                        if (player != null) {
                            player.method_43496((class_2561)class_2561.method_43470((String)"The server has disallowed the use of schematics").method_27692(class_124.field_1061));
                        }
                    } else {
                        Path schematicDir = SchematicLoader.getDefaultSchematicDir();
                        Object schematicDirStr = schematicDir.toString();
                        if (!((String)schematicDirStr).endsWith(separator = schematicDir.getFileSystem().getSeparator())) {
                            schematicDirStr = (String)schematicDirStr + separator;
                        }
                        future = AsyncFileDialogs.openFileDialog((String)schematicDirStr, "Schematic Files", "schem", "schematic");
                        future.thenAccept(path -> {
                            if (path == null) {
                                Axiom.LOGGER.info("Skipping schematic load since file dialog was cancelled");
                                return;
                            }
                            Axiom.LOGGER.info("Loading schematic from file: {}", path);
                            try {
                                ClipboardObject clipboardObject;
                                Path file = Path.of(path, new String[0]);
                                class_2487 tag = class_2507.method_30613((File)file.toFile());
                                if (tag.method_10545("Version")) {
                                    clipboardObject = SchematicLoader.loadSpongeV2(tag);
                                } else if (tag.method_10545("Materials")) {
                                    clipboardObject = SchematicLoader.loadLegacy(tag);
                                } else {
                                    throw new SchematicLoader.SchematicLoadException("Unknown format");
                                }
                                class_310.method_1551().method_20493(() -> Clipboard.INSTANCE.setClipboard(clipboardObject));
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                                String message = e.getMessage();
                                class_310.method_1551().method_20493(() -> class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)message).method_27692(class_124.field_1061)));
                            }
                        });
                    }
                }
                if (clipboardEmpty) {
                    ImGuiHelper.disabledMenuItem(AxiomI18n.get("axiom.editorui.mainmenu.export_schematic"), AxiomI18n.get("axiom.tool.painter.clipboard_empty_warning"));
                } else if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.export_schematic"))) {
                    ClipboardObject clipboardObject = Clipboard.INSTANCE.getClipboard();
                    if (clipboardObject instanceof ClipboardObject.Anonymous) {
                        ClipboardObject.Anonymous anonymous = (ClipboardObject.Anonymous)clipboardObject;
                        ExportSchematicWindow.open(clipboardObject.blockRegion(), clipboardObject.blockEntities(), anonymous.additionalSchematicData());
                    } else {
                        ExportSchematicWindow.open(clipboardObject.blockRegion(), clipboardObject.blockEntities(), null);
                    }
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.open_reference_image"))) {
                    path2 = FabricLoader.getInstance().getGameDir();
                    dirStr = path2.toString();
                    if (!((String)dirStr).endsWith(separator = path2.getFileSystem().getSeparator())) {
                        dirStr = (String)dirStr + separator;
                    }
                    future = AsyncFileDialogs.openFileDialog((String)dirStr, "Image Files", "png", "jpeg", "jpg");
                    future.thenAccept(imagePath -> {
                        if (imagePath == null) {
                            Axiom.LOGGER.info("Skipping open reference image since file dialog was cancelled");
                            class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)"Cancelled open file, aborting").method_27692(class_124.field_1054));
                            return;
                        }
                        Axiom.LOGGER.info("Opening reference image from file: {}", imagePath);
                        class_310.method_1551().method_20493(() -> {
                            Path file = Path.of(imagePath, new String[0]);
                            try {
                                BufferedImage image = ImageIO.read(Files.newInputStream(file, new OpenOption[0]));
                                int width = image.getWidth();
                                int height = image.getHeight();
                                class_1011 nativeImage = new class_1011(width, height, true);
                                for (int x = 0; x < width; ++x) {
                                    for (int y = 0; y < height; ++y) {
                                        int argb = image.getRGB(x, y);
                                        int alpha = argb >> 24 & 0xFF;
                                        int red = argb >> 16 & 0xFF;
                                        int green = argb >> 8 & 0xFF;
                                        int blue = argb & 0xFF;
                                        nativeImage.method_4305(x, y, class_5253.class_8045.method_48344((int)alpha, (int)blue, (int)green, (int)red));
                                    }
                                }
                                ImageReferenceWindows.add(nativeImage);
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                                class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)e.getMessage()).method_27692(class_124.field_1061));
                            }
                        });
                    });
                }
                if (!Axiom.getInstance().hasCommercialLicense()) {
                    ImGui.beginDisabled();
                    ImGui.menuItem("Load Bedrock Packs");
                    ImGui.endDisabled();
                    ImGuiHelper.tooltip("Loading Bedrock Behaviour/Resource Packs is a Commercial License feature", 512);
                } else if (ImGui.menuItem("Load Bedrock Packs")) {
                    path2 = FabricLoader.getInstance().getGameDir();
                    dirStr = path2.toString();
                    if (!((String)dirStr).endsWith(separator = path2.getFileSystem().getSeparator())) {
                        dirStr = (String)dirStr + separator;
                    }
                    future = AsyncFileDialogs.openFolderDialog((String)dirStr);
                    future.thenAccept(folderPath -> {
                        if (folderPath == null) {
                            Axiom.LOGGER.info("Skipping load bedrock packs since file dialog was cancelled");
                            class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)"Cancelled open folder, aborting").method_27692(class_124.field_1054));
                            return;
                        }
                        Axiom.LOGGER.info("Opening bedrock packs from file: {}", folderPath);
                        class_310.method_1551().method_20493(() -> {
                            try {
                                Path folder = Path.of(folderPath, new String[0]);
                                BedrockPackLoader.loadFolder(folder);
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                                class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)e.getMessage()).method_27692(class_124.field_1061));
                            }
                        });
                    });
                }
                if (BedrockModelRegistry.INSTANCE.hasModelsOrResources() && ImGui.menuItem("Unload Bedrock Packs")) {
                    BedrockModelRegistry.INSTANCE.clear();
                    class_310.method_1551().method_1521();
                }
                if (Selection.getSelectionBuffer().isEmpty()) {
                    ImGuiHelper.disabledMenuItem("Save Selection as CSV", "Selection is empty");
                } else if (ImGui.menuItem("Save Selection as CSV")) {
                    class_638 level = class_310.method_1551().field_1687;
                    class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
                    StringBuilder stringBuilder = new StringBuilder();
                    Selection.getSelectionBuffer().forEach((x, y, z) -> {
                        class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                        if (!blockState.method_26215()) {
                            stringBuilder.append(class_2259.method_9685((class_2680)blockState).replace(",", ";"));
                            stringBuilder.append(',');
                            stringBuilder.append(x);
                            stringBuilder.append(',');
                            stringBuilder.append(y);
                            stringBuilder.append(',');
                            stringBuilder.append(z);
                            stringBuilder.append('\n');
                        }
                    });
                    future = AsyncFileDialogs.saveFileDialog(FabricLoader.getInstance().getGameDir().toString(), "blocks.csv", "Comma Separated Values", "csv");
                    future.thenAccept(filePath -> {
                        if (filePath == null) {
                            Axiom.LOGGER.info("Skipping save blocks as csv since file dialog was cancelled");
                            class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)"Cancelled file save, aborting").method_27692(class_124.field_1054));
                            return;
                        }
                        Axiom.LOGGER.info("Saving blocks as csv to file: {}", filePath);
                        class_310.method_1551().method_20493(() -> {
                            try {
                                Path file = Path.of(filePath, new String[0]);
                                Files.writeString(file, (CharSequence)stringBuilder, new OpenOption[0]);
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                                class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)e.getMessage()).method_27692(class_124.field_1061));
                            }
                        });
                    });
                }
                if (clipboardEmpty) {
                    ImGuiHelper.disabledMenuItem("Save Clipboard as JSON Model", "Clipboard is empty");
                } else if (ImGui.menuItem("Save Clipboard as JSON Model")) {
                    JsonObject jsonObject = BlocksToJsonModel.convertBlocksToJsonModel(Clipboard.INSTANCE.getClipboard().blockRegion());
                    CompletableFuture<String> future2 = AsyncFileDialogs.saveFileDialog(FabricLoader.getInstance().getGameDir().toString(), "model.json", "JSON", "json");
                    future2.thenAccept(filePath -> {
                        if (filePath == null) {
                            Axiom.LOGGER.info("Skipping save clipboard as model since file dialog was cancelled");
                            class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)"Cancelled file save, aborting").method_27692(class_124.field_1054));
                            return;
                        }
                        Axiom.LOGGER.info("Saving clipboard as model to file: {}", filePath);
                        class_310.method_1551().method_20493(() -> {
                            try {
                                Path file = Path.of(filePath, new String[0]);
                                Files.writeString(file, (CharSequence)new Gson().toJson((JsonElement)jsonObject), new OpenOption[0]);
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                                class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)e.getMessage()).method_27692(class_124.field_1061));
                            }
                        });
                    });
                }
                ImGui.endMenu();
            }
            if (ImGui.beginMenu(AxiomI18n.get("axiom.editorui.mainmenu.edit"))) {
                int historyPosition = Dispatcher.getHistoryPosition();
                if (historyPosition < 0) {
                    ImGui.beginDisabled();
                    ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.edit.undo"), Keybinds.UNDO.longKeyIdentifier());
                    ImGui.endDisabled();
                } else {
                    data = Dispatcher.getHistoryData(historyPosition);
                    String undoMessage = AxiomI18n.get("axiom.editorui.mainmenu.edit.undo_named", ((Dispatcher.HistoryData)data).entry().description());
                    if (ImGui.menuItem(undoMessage, Keybinds.UNDO.longKeyIdentifier())) {
                        Dispatcher.callAction(UserAction.UNDO, null);
                    }
                }
                if (historyPosition + 1 >= Dispatcher.getHistoryDataCount()) {
                    ImGui.beginDisabled();
                    ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.edit.redo"), Keybinds.REDO.longKeyIdentifier());
                    ImGui.endDisabled();
                } else {
                    data = Dispatcher.getHistoryData(historyPosition + 1);
                    String redoMessage = AxiomI18n.get("axiom.editorui.mainmenu.edit.redo_named", ((Dispatcher.HistoryData)data).entry().description());
                    if (ImGui.menuItem(redoMessage, Keybinds.REDO.longKeyIdentifier())) {
                        Dispatcher.callAction(UserAction.REDO, null);
                    }
                }
                ImGui.separator();
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.edit.cut"), Keybinds.CUT.longKeyIdentifier(), false, selectionActive)) {
                    UserAction.CUT.call(null);
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.edit.copy"), Keybinds.COPY.longKeyIdentifier(), false, selectionActive)) {
                    UserAction.COPY.call(null);
                }
                ImGui.separator();
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.edit.save_blueprint"), Keybinds.SAVE_BLUEPRINT.longKeyIdentifier(), false, clipboardNonEmpty)) {
                    UserAction.SAVE.call(null);
                }
                ImGui.endMenu();
            }
            if (ImGui.beginMenu(AxiomI18n.get("axiom.editorui.mainmenu.select"))) {
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.select.clear"), AxiomI18n.get("key.keyboard.enter"), false, selectionActive)) {
                    Selection.clearSelection();
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.select.filter"))) {
                    EditorWindowType.FILTER_SELECTION.setOpen(true);
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.select.expand"))) {
                    EditorWindowType.EXPAND_SELECTION.setOpen(true);
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.select.shrink"))) {
                    EditorWindowType.SHRINK_SELECTION.setOpen(true);
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.select.distort"))) {
                    EditorWindowType.DISTORT_SELECTION.setOpen(true);
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.select.smooth"))) {
                    EditorWindowType.SMOOTH_SELECTION.setOpen(true);
                }
                if ((data = Selection.getSelectionBuffer()) instanceof SelectionBuffer.Set) {
                    SelectionBuffer.Set set = (SelectionBuffer.Set)data;
                    if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.select.bounding_box"))) {
                        Selection.addAABB(set.min(), set.max());
                    }
                } else {
                    ImGui.beginDisabled();
                    ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.select.bounding_box"));
                    ImGui.endDisabled();
                }
                ImGui.endMenu();
            }
            if (ImGui.beginMenu(AxiomI18n.get("axiom.editorui.mainmenu.view"))) {
                boolean canAddView;
                boolean bl2 = canAddView = config.editableEditorViews() && ViewManager.getViews().size() < config.maximumEditorViews();
                if (!canAddView) {
                    ImGui.beginDisabled();
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.view.create_new"))) {
                    ViewManager.addNewView();
                }
                if (!canAddView) {
                    ImGui.endDisabled();
                }
                ImGui.separator();
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.view.show_selection"), Keybinds.SHOW_SELECTION.longKeyIdentifier(), Selection.shouldRenderSelection())) {
                    Selection.setShouldRenderSelection(!Selection.shouldRenderSelection());
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.view.show_biomes"), Keybinds.SHOW_BIOMES.longKeyIdentifier(), BiomeOverlayRenderer.INSTANCE.isActive())) {
                    BiomeOverlayRenderer.INSTANCE.setActive(!BiomeOverlayRenderer.INSTANCE.isActive());
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.view.show_key_presses"), "", Configuration.rendering.keypressOverlay)) {
                    Configuration.rendering.keypressOverlay = !Configuration.rendering.keypressOverlay;
                }
                float[] uiScale = new float[]{EditorUI.newGlobalScale};
                ImGui.setNextItemWidth(100.0f * EditorUI.getUiScale());
                if (ImGui.sliderFloat(AxiomI18n.get("axiom.editorui.mainmenu.view.ui_scale"), uiScale, 0.5f, 2.0f)) {
                    EditorUI.newGlobalScale = uiScale[0];
                }
                float[] minBrightness = new float[]{Configuration.rendering.minBrightness};
                ImGui.setNextItemWidth(100.0f * EditorUI.getUiScale());
                if (ImGui.sliderFloat(AxiomI18n.get("axiom.editorui.mainmenu.view.min_brightness"), minBrightness, 0.0f, 1.0f)) {
                    Configuration.rendering.minBrightness = minBrightness[0];
                }
                float[] liquidOpacity = new float[]{Configuration.rendering.liquidOpacity};
                ImGui.setNextItemWidth(100.0f * EditorUI.getUiScale());
                if (ImGui.sliderFloat(AxiomI18n.get("axiom.editorui.mainmenu.view.liquid_opacity"), liquidOpacity, 0.0f, 1.0f)) {
                    Configuration.rendering.liquidOpacity = liquidOpacity[0];
                }
                ImGui.endMenu();
            }
            MainMenuBar.renderOperationsImgui(true);
            if (ImGui.beginMenu(AxiomI18n.get("axiom.editorui.mainmenu.toolmasks"))) {
                boolean canClear = MaskManager.hasConfiguredMask();
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.toolmasks.clear"), null, false, canClear)) {
                    MaskManager.setConfiguredMask(null, true, true);
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.toolmasks.edit"))) {
                    EditorWindowType.TOOL_MASKS.setOpen(true);
                }
                ImGui.endMenu();
            }
            if (ImGui.beginMenu(AxiomI18n.get("axiom.editorui.mainmenu.window"))) {
                String clipboard;
                boolean allowLoadingLayout;
                if (ImGui.menuItem("Store Current Layout as Default")) {
                    Configuration.internal.defaultLayout = MainMenuBar.storeLayout();
                }
                if (ImGui.menuItem("Restore Default Layout")) {
                    MainMenuBar.restoreLayout(Configuration.internal.defaultLayout);
                }
                ImGui.separator();
                if (ImGui.menuItem("Copy Current Layout to Clipboard")) {
                    class_310.method_1551().field_1774.method_1455(MainMenuBar.storeLayout());
                }
                if (!(allowLoadingLayout = (clipboard = class_310.method_1551().field_1774.method_1460()).contains("[Docking][Data]"))) {
                    ImGui.beginDisabled();
                }
                if (ImGui.menuItem("Load Layout from Clipboard")) {
                    MainMenuBar.restoreLayout(clipboard);
                }
                if (!allowLoadingLayout) {
                    ImGui.endDisabled();
                }
                ImGui.separator();
                InternalConfiguration internal = Configuration.internal;
                if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.mainmenu.window.show_close_window_button"), internal.showCloseWindowButton)) {
                    internal.showCloseWindowButton = !internal.showCloseWindowButton;
                }
                ImGui.separator();
                if (ImGui.beginMenu(AxiomI18n.get("axiom.editorui.mainmenu.window.windows"))) {
                    for (EditorWindowType windowType : EditorWindowType.values()) {
                        if (!windowType.isImportant()) continue;
                        ImBoolean open2 = new ImBoolean(windowType.isOpen());
                        ImGui.checkbox(windowType.getName(), open2);
                        windowType.setOpen(open2.get());
                    }
                    ImGui.endMenu();
                }
                ImGui.endMenu();
            }
            if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.help.keybinds"))) {
                EditorWindowType.KEYBINDS.setOpen(true);
            }
            if (ImGui.beginMenu(AxiomI18n.get("axiom.editorui.mainmenu.help"))) {
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.help.discord_server"))) {
                    String discord = "https://discord.gg/axiomtool/";
                    class_310.method_1551().method_1507((class_437)new class_407(open -> {
                        if (open) {
                            try {
                                class_156.method_668().method_673(new URI(discord));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        class_310.method_1551().method_1507(null);
                    }, discord, false));
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.help.documentation"))) {
                    String docs = "https://axiomdocs.moulberry.com/";
                    class_310.method_1551().method_1507((class_437)new class_407(open -> {
                        if (open) {
                            try {
                                class_156.method_668().method_673(new URI(docs));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        class_310.method_1551().method_1507(null);
                    }, docs, false));
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.help.style_editor"))) {
                    EditorWindowType.STYLE_EDITOR.setOpen(true);
                }
                if (ImGui.beginMenu(AxiomI18n.get("axiom.editorui.mainmenu.help.reset_tutorial"))) {
                    if (ImGui.menuItem("Introduction")) {
                        TutorialManager.reset(Tutorial.INTRODUCTION);
                    }
                    if (ImGui.menuItem("Selection")) {
                        TutorialManager.reset(Tutorial.SELECTION);
                    }
                    if (ImGui.beginMenu("Tools")) {
                        if (ImGui.menuItem("Magic Select")) {
                            TutorialManager.reset(Tutorial.MAGIC_SELECT_TOOL);
                        }
                        if (ImGui.menuItem("Box Select")) {
                            TutorialManager.reset(Tutorial.BOX_SELECT_TOOL);
                        }
                        if (ImGui.menuItem("Slope")) {
                            TutorialManager.reset(Tutorial.SLOPE_TOOL);
                        }
                        if (ImGui.menuItem("Sculpt Draw")) {
                            TutorialManager.reset(Tutorial.SCULPT_DRAW_TOOL);
                        }
                        ImGui.endMenu();
                    }
                    ImGui.endMenu();
                }
                ImGui.endMenu();
            }
            ImGui.endMainMenuBar();
        }
    }

    @NotNull
    private static String storeLayout() {
        String iniSettingsStr = ImGui.saveIniSettingsToMemory();
        boolean addNewline = !iniSettingsStr.endsWith("\n");
        StringBuilder iniSettings = new StringBuilder(iniSettingsStr);
        if (addNewline) {
            iniSettings.append("\n");
        }
        iniSettings.append("[AxiomWindows]\n");
        for (String openWindow : EditorWindowType.getOpenByName()) {
            iniSettings.append(openWindow).append("\n");
        }
        return iniSettings.toString();
    }

    private static void restoreLayout(String layout) {
        if (!layout.contains("[Docking][Data]")) {
            return;
        }
        String[] split = layout.split("\\[AxiomWindows\\]");
        String imgui = split[0].trim();
        ImGui.loadIniSettingsFromMemory(imgui);
        if (split.length >= 2) {
            String axiom = split[1].trim();
            String[] windows = axiom.split("\n");
            ArrayList<String> openByName = new ArrayList<String>();
            for (String window : windows) {
                openByName.add(window.trim());
            }
            EditorWindowType.setOpenByName(openByName);
        } else {
            EditorWindowType.setOpenToDefault();
        }
    }

    public static void renderOperationsImgui(boolean menu) {
        if (menu) {
            if (!ImGui.beginMenu(AxiomI18n.get("axiom.editorui.mainmenu.operations"))) {
                return;
            }
        } else {
            if (ImGui.button(AxiomI18n.get("axiom.editorui.mainmenu.operations") + "...")) {
                ImGui.openPopup("OperationsPopup");
            }
            if (!ImGuiHelper.beginPopup("OperationsPopup")) {
                return;
            }
        }
        if (ImGui.beginMenu(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_category"))) {
            if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill"), Keybinds.QUICK_FILL.longKeyIdentifier())) {
                FillBlocksWindow.setFillType(0);
                EditorWindowType.FILL.setOpen(true);
            }
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_description"));
            if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_outline"))) {
                FillBlocksWindow.setFillType(2);
                EditorWindowType.FILL.setOpen(true);
            }
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_outline_description"));
            if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_walls"))) {
                FillBlocksWindow.setFillType(3);
                EditorWindowType.FILL.setOpen(true);
            }
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_walls_description"));
            if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_top"))) {
                FillBlocksWindow.setFillType(4);
                EditorWindowType.FILL.setOpen(true);
            }
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_top_description"));
            if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_bottom"))) {
                FillBlocksWindow.setFillType(5);
                EditorWindowType.FILL.setOpen(true);
            }
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_bottom_description"));
            ImGui.endMenu();
        }
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_nearest"))) {
            FillNearestOperation.fillNearest();
        }
        ImGuiHelper.tooltip(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_nearest_description"));
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.replace"), Keybinds.QUICK_REPLACE.longKeyIdentifier())) {
            EditorWindowType.REPLACE.setOpen(true);
        }
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.type_replace"))) {
            EditorWindowType.TYPE_REPLACE.setOpen(true);
        }
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.set_biome"))) {
            EditorWindowType.SET_BIOME.setOpen(true);
        }
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.autoshade"))) {
            EditorWindowType.AUTOSHADE.setOpen(true);
        }
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.drain"))) {
            DrainOperation.drain();
        }
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.waterlog"))) {
            WaterlogOperation.waterlog();
        }
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.smoothsnow"))) {
            SmoothSnow.smoothSnow();
        }
        ImGui.separator();
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.simulate_gravity"))) {
            SimulateGravityOperation.gravity();
        }
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.trigger_updates"))) {
            UpdateBlocksOperation.updateBlocks();
        }
        ImGui.separator();
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.hollow"))) {
            HollowOperation.hollow();
        }
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_gaps"))) {
            HollowOperation.fillGaps();
        }
        ImGui.separator();
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.generate_colour_field"))) {
            GenerateColourFieldOperation.generateColourField();
        }
        ImGui.separator();
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.analyze"))) {
            EditorWindowType.ANALYZE.setOpen(true);
        }
        if (ImGui.menuItem("Animated Rebuild...")) {
            EditorWindowType.ANIMATED_REBUILD.setOpen(true);
        }
        ImGuiHelper.tooltip("Gradually rebuilds a selection block-by-block. This feature is intended for content creators making video showcases of a build");
        if (menu) {
            ImGui.endMenu();
        } else {
            ImGui.endPopup();
        }
    }
}

